;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;	Copyright (C) 2010    Muris Pucic (Trax)
;	Website: http://www.elektronika.ba/
;
;	Phone dojava: Phone-line call alerting alarm module
;
;   This program is free software: you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, either version 3 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;********************************************
;
;	Phone Dojava (-controller)
;	==========================
;
; Modify datum | Razlog
; ---------------------------
; 16/07/2006   | Pocetak projekta.
; 17/07/2006   | Kraj. Testiranje, debugiranje. Sve radi.
; 00/07/2006   | 
;
; Programiranje uredjaja:
; - pritisnuti program dugme
; - podignuti slusalicu na telefonu koji je spojen na istoj liniji
; - ukucati prvi broj za poziv, a na kraju njega znak *
; - ukucati drugi broj za poziv, a na kraju njega znak *
; - ukucati tako brojeva koliko zelite, a na kraju zavrsiti sa *#
;   - primjer: 061280399*061440378*#
;
; NOTE: maksimalno moze biti 64 karaktera ukucana u programiranju
;       ukljucujuci znakove * i #.
;
;********************************************

;***** Deklaracija i konfigurisanje mikrokontrolera *****

        PROCESSOR 16f84A
        #include "p16f84a.inc"

		ERRORLEVEL	0,	-302	;suppress bank selection messages

		__CONFIG _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC

;***** Deklaracija hardvera *****

#define	DB0		PORTB, 0	; databus
#define DB1		PORTB, 1	; databus
#define DB3		PORTB, 2	; databus
#define DB4		PORTB, 3	; databus
#define	MT_RS0	PORTB, 4	; RS0 - MT8880 register select
#define	MT_CLK	PORTB, 5	; o2 - MT8880 clock
#define MT_IRQ	PORTB, 6	; IRQ - MT8880 je primio DTMF podatak (Vcc->GND)
#define MT_RW	PORTB, 7	; R/W - MT8880 read/-write

#define DIALMOD	PORTA, 0	; tone(high) - pulse(low)
#define LED		PORTA, 1	; status LED
#define	ONHOOK	PORTA, 2	; ON-HOOK relay
#define GODIAL	PORTA, 3	; alarm impuls, dial now!
#define PROG	PORTA, 4	; programiranje alarma mod

#define bINTER	BOOLEAN, 0	; interupt se desio...
#define	bFRSTD	BOOLEAN, 1	; first dial? da ne pravimo pauzu kod prvog zvanja

;***** Deklaracija konstanti i varijabli *****

TEMP1		equ	0x0C		; 
TEMP2		equ	0x0D		; 
BOOLEAN		equ	0x0E		; neke boolean vrijednosti - 8 varijabli :)
SEKUNDI		equ	0x0F		; 
MT_DATA		equ	0x10		; podatak sa MT-a
MT_TMP		equ	0x11		; temp
CKERR		equ	0x12		; interrupt err cheker
CKERR1		equ	0x13		; interrupt err cheker

digit_1		equ	b'00000001'	; Setting the variables to phone digits
digit_2		equ	b'00000010' ; used by phone and the program to detect
digit_3		equ	b'00000011' ; key presses
digit_4		equ	b'00000100'
digit_5		equ	b'00000101'
digit_6		equ	b'00000110'
digit_7		equ	b'00000111'
digit_8		equ	b'00001000'
digit_9		equ	b'00001001'
digit_0		equ	b'00001010'
digit_x		equ	b'00001011'
digit_#		equ	b'00001100'
digit_A		equ	b'00001101'
digit_B		equ	b'00001110'
digit_C		equ	b'00001111'
digit_D		equ	b'00000000'

;***** Struktura programske memorije *****

		ORG		0x00		; Reset vektor
  		GOTO	Init		;

		ORG		0x04		; Interapt vektor
		GOTO	Intrpt		;

;***** Interupt rutina *****

Intrpt	bcf		INTCON, GIE	; onemoguci sve interupte za sad
		bcf		INTCON, T0IF; skini flag od ovog interrupta

		incf	CKERR, 1	; cnt1++
		btfsc	STATUS, Z	; preskoci ako rezultat inkrementa nije nula, odradi ako jest nula
		incf	CKERR1, 1	; cnt2++
		btfsc	STATUS, Z	; preskoci ako rezultat inkrementa nije nula, odradi ako jest nula
		GOTO	Intrpt1		; interrupt javi da se desio

		clrf	TMR0		; resetuj tmr0 da krenemo od nule opet a ne od nule + ove instrukcije odozgo
		RETFIE				; vrachamo se...

Intrpt1	bsf		bINTER		; da onaj tamo zna da se interrupt desio i da moze preci na naredni broj u zvanju
		RETURN				; samo se vrati normalno bez ukljucivanja interrupta opet!!!

;***** Interupt enabler i inicijaler *****

CkIni	clrf	TMR0		; odma na pocetku ovo treba ! nikad se ne zna koliki je tmr0 kad program uleti odnekud ovdje ! trebao bi i jedan prije RETURN-a dole
		clrf	CKERR		; init varijable koja se koristi u interupt rutini
		clrf	CKERR1		; init varijable koja se koristi u interupt rutini
		bsf		INTCON, T0IE; omoguci prekid na tmr0 kad predje sa FFh na 00h
		bsf		INTCON, GIE	; omoguci sve prekide ! main switch on :)
		RETURN				; vrati se...

;***** Interupt disabler ******

CkDeIni	clrf	INTCON		; interrupti ugaseni
		RETURN				; vrati se...

;***** Moja pauze - od prilike 100ms *****

Pauza12	movlw	h'10'		; w=XXh
		movwf	TEMP1		; TEMP1=w
		GOTO	Pauza_Y		;
Pauza13	movlw	h'87'		; w=XXh
		movwf	TEMP1		; TEMP1=w
		GOTO	Pauza_Y		;
Pauza1	movlw	h'FF'		; w=XXh
		movwf	TEMP1		; TEMP1=w
Pauza_Y	decfsz	TEMP1, 1	;
		GOTO	Pauza_X		;
		RETURN				; vrati se...
Pauza_X	movlw	h'FF'		;
		movwf	TEMP2		;
Pauza_Z	decfsz	TEMP2, 1	;
		GOTO	Pauza_Z		;
		GOTO	Pauza_Y		;

;***** While petlja sa pauzom (SEKUNDI*Pauza1) *****

BigWait	CALL	Pauza1		;
		decf	SEKUNDI, 1	; SEKUNDI--
		btfss	STATUS, Z	; do if not zero
		GOTO	BigWait		;
		RETURN				; vrati se stari moj...

;***** Pisanje u EEPROM *****

EE_Pisi	bsf		STATUS, RP0	; banka 1 ... prije ovog trebali smo ubaciti podatke u EEDAT i EEADR :) pa tek onda doletit u ovu proceduru ! :)
		bsf		EECON1, WREN; dozvoli upis u eeprom
		movlw	h'55'		; kljuc1
		movwf	EECON2		; --- unlock
		movlw	h'AA'		; kljuc2
		movwf	EECON2		; --- unlock
		bsf		EECON1, WR	; PISI
EE_Pis1	btfsc	EECON1, WR	; ako se nije zavrsio upis
		GOTO	EE_Pis1		; vrati se i cekaj da se zavrsi vala
		bcf		EECON1, WREN; onemoguci upise u eeprom na dalje
		bcf		STATUS, RP0	; banka 0
		RETURN				; vrati se..

;***** Citanje iz EEPROM-a *****

EE_Read	bsf		STATUS, RP0	; banka 1
		bsf		EECON1, RD	; EE read
		bcf		STATUS, RP0	; banka 0
		RETURN				; vrati se..

;***** Toggle-Blink LED *****

BlinkLed
		btfss	LED			; ako je ugasena
		GOTO	BlinkLed1	; haj vamo da ge upalimo
		btfsc	LED			; ili ako je upaljena
		bcf		LED			; gasi je
		RETURN				; vrati se...
BlinkLed1
		bsf		LED			; pali je
		RETURN				; vrati se...

;***** Inicijalizacija PIC-a *****

Init	clrf	INTCON		; interrupti ugaseni
		bsf		STATUS, RP0	; bank 1
		movlw	b'00000000'	; 
		movwf	OPTION_REG	; izmedju ostalog ukljuci pull-ups, 1:2 prescaler
		movlw	b'01001111'	; 
		movwf	TRISB		; trisb
		movlw	b'00011001'	; 
		movwf	TRISA		; trisa
		bcf		STATUS, RP0	; bank 0
		clrf	BOOLEAN		; ovo se mora odraditi !
		bcf		ONHOOK		; gasi relej
		; inicijalizuj ga 2 put, prvi put ne prodje inace...
		bsf		LED			; pali led - busy
		CALL	Pauza1		; moras sacekati 100ms da se MT8880 upali
		CALL	init_8880	; init MT8880
		CALL	Pauza1		; moras sacekati 100ms da se MT8880 upali
		CALL	Pauza1		; moras sacekati 100ms da se MT8880 upali
		CALL	init_8880	; init MT8880
		CALL	Pauza1		; moras sacekati 100ms da se MT8880 upali
		bcf		LED			; gasi led - ready
		; idliraj...
		GOTO	Idle		; idliraj...

;***** Inicijalizacija MT8880 *****

init_8880
		CALL	read_8880ctrl		; -Reading the Status register
		clrw
		CALL	write_8880ctrl		; -Writting to control Registers
		clrw
		CALL	write_8880ctrl		; -Writting to control Registers
        movlw   b'00001000'
		CALL	write_8880ctrl		; -Writting to control Registers
		clrw
		CALL	write_8880ctrl		; -Writting to control Registers
		CALL	read_8880ctrl		; -Reading the Status register

        movlw   b'00001101'			; Write to control Register A (tone out, DTMF, IRQ, Select Control Register)
        CALL	write_8880ctrl		; -Writing to the 8880 register

        movlw   b'00000000'			; Write to control register B (burst mode)
        CALL	write_8880ctrl		; -Writing to the 8880 register

        RETURN

;***** Reading Registers of the MT8880 data&control into "W" reg. *****

read_8880
		bcf		MT_RS0				; RS=0 (data)
		GOTO	read_8880ex			; skip control-type reading
read_8880ctrl
		bsf		MT_RS0				; RS=1 (control)
read_8880ex
		CALL	DB_TRIS1			; tris input
		bsf		MT_RW				; RW=1 (read)

		bsf		MT_CLK				; clocking up the 8880
		movfw	PORTB				; storing the data from the bus
		movwf	MT_DATA				; moving the data to MT_DATA register
		bcf		MT_CLK				; clocking down the 8880

		; treba ocistiti gornji nibble na nulu
		movlw	h'0F'				; W=00001111
		andwf	MT_DATA, 0	;,1		; MT_DATA=MT_DATA & W ... sad je: W=, a ne MT_DATA= !!!!!!
		RETURN

;***** Writing "W" to Registers of the MT8880 data&control *****

write_8880
		bcf		MT_RS0				; RS=0 (data)
		GOTO	write_8880ex		; skip control-type writing
write_8880ctrl
		bsf		MT_RS0				; RS=1 (control)
write_8880ex
		bcf		MT_RW				; RW=0 (write)

		; ocisti gornji nibble podatka, treba mi samo donji
		movwf	MT_DATA				; podatak koji saljem je u MT_DATA
		movlw	h'0F'				; w=0Fh
		andwf	MT_DATA, 1			; MT_DATA = MT_DATA & 0Fh - da se osiguramo da imamo samo donji nibble

		; uzmi stanje sa PORTB-a i zadrzi samo gornji nibble
		movfw	PORTB
		movwf	MT_TMP				; MT_TMP=PORTB
		movlw	h'F0'				; W=F0h - sad trebamo zadrzati samo gornji nibble ovog bajta, donji postavljam na null
		andwf	MT_TMP, 1			; MT_TMP = MT_TMP & 11110000

		CALL	DB_TRIS0			; tris output

		; spoji nibblove i baci na PORTB
		movfw	MT_TMP				; W = MT_TMP
		iorwf	MT_DATA, 0			; W = MT_DATA || MT_TMP - sklopio sam MT_DATA u W
        movwf   PORTB				; PORTB=W

        bsf		MT_CLK				; clocking up the 8880
        nop
        bcf		MT_CLK				; clocking donw the 8880
		nop

		bsf		MT_RW				; RW=1 (read)
		CALL	DB_TRIS1			; tris input
        RETURN

;***** Kupljenje podatka sa MT8880 u "W" registar *****

get_8880
		CALL	read_8880ctrl		; da ocistimo interrupt flag
		nop
		CALL	read_8880			; uzmi podatak u MT_DATA
		RETURN						; vrati se...

;***** Slanje DTMF tona na MT8880 iz "W" registra *****

put_8880
		CALL	write_8880			; salji W reg dtmf-om
		nop
put_88a	CALL	read_8880ctrl		; procitaj status-reg u W
		movwf	MT_DATA				; mt_data=w
		nop
		btfss	MT_DATA, 1			; do if clear
		GOTO	put_88a				; idi citaj status-reg sve dok ne bude REZ.2==1
		RETURN						; vrati se...

;***** Pulsno biranje broja u "W" registru *****

puls_dial
		movwf	MT_TMP				; broj za biranje je u TEMP2
		;incf	MT_TMP, 2			; ++
puls_dial1
		bcf		ONHOOK				; spusti
		CALL	Pauza13				; cek
		bsf		ONHOOK				; digni
		CALL	Pauza13				; cek

		decfsz	MT_TMP, 1			; --, skip if zero
		GOTO	puls_dial1			; jos

		movlw	d'6'				; w=8*Pauza1
		movwf	SEKUNDI				; =w
		CALL	BigWait				; cekaj

		RETURN						; vrati se...

;***** DATABUS tris input *****

DB_TRIS1; postavi TRISB 0..3 na input
		bsf		STATUS, RP0
		movlw	b'01001111'	; input
		movwf	TRISB		; trisb		
		bcf		STATUS, RP0
		RETURN

;***** DATABUS tris output *****

DB_TRIS0; postavi TRISB 0..3 na output
		bsf		STATUS, RP0
		movlw	b'01000000'	; output
		movwf	TRISB		; trisb		
		bcf		STATUS, RP0
		RETURN

;***** Idle *****

Idle	clrf	TEMP1		; =0
		clrf	TEMP2		; =0
Idle0	incf	TEMP1, 1	; ++ I
		btfsc	STATUS, Z	; do if set, do if overflow
		incf	TEMP2, 1	; ++ II
		btfsc	STATUS, Z	; do if set, do if overflow
		CALL	BlinkLed	; blinkni jednom!

		btfss	PROG		; do if program-mode
		GOTO	ProgMode	; idi u program mode

		btfss	GODIAL		; do if clear
		GOTO	DialAlarm	; zovi...

		GOTO	Idle0		; inace iz pocetka...

;***** Program mod *****
; snimanje u EEPROM sve do # ukljucujuci i njega. max 64 bajta je
; kapacitet internog eeproma f84a chipa

ProgMode
		btfss	PROG		; do if clear
		GOTO	$-1			; cekaj da pusti prog-dugme
		CALL	Pauza1		; cek tren...
		bsf		LED			; pali led jer smo u program-modu
ProgMode1
		clrf	EEADR		; adr=0
		; posto je !GARANT/DEFINITIVNO! barem jedna cifra vec na cekanju u
		; MT8880, mi cemo ocistiti IRQ flag u njegovom status-registru zato
		CALL	get_8880	; procitaj junk cifru koja nas ceka u chipu od prije
ProgMode2
		btfss	PROG		; do if clear
		GOTO	ProgEnd		; zavrsi programiranje jer se predomislio
		; sad uzimaj brojke i snimaj u eeprom!
		btfsc	MT_IRQ		; do if set, pa cekaj da bude clear
		GOTO	ProgMode2	; cekaj DTMF podatak da bude ready
		; podatak je u MT-u, trebamo ga ufatit :)
		bcf		LED			; gasi LED...
		CALL	get_8880	; sad imamo DTMF podatak u W-u
		movwf	EEDATA		; EEDATA=W
		movwf	MT_DATA		; MT_DATA=W - kopija
		CALL	EE_Pisi		; upisi ga u eeprom!
		incf	EEADR, 1	; adr+1
		bsf		LED			; pali LED...

		; jel #?
		movlw	digit_#		; W=#
		subwf	MT_DATA, 0	; W=MT_DATA-#
		btfss	STATUS, Z	; do if clear, uradi ako nije to taj znak
		GOTO	ProgMode2	; jos...
ProgEnd	; jest dosla je # ili je pritisnuo dugme za kraj, javi da je prog-finito
		btfss	PROG		; do if clear
		GOTO	$-1			; cekaj da pusti prog-dugme
		CALL	Pauza1		; cek tren prije pjevanja...
		CALL	Pauza1		; cek tren prije pjevanja...
		bcf		LED			; gasi led...

		movlw	digit_1		; 1
		CALL	put_8880	; send
		movlw	digit_5		; 5
		CALL	put_8880	; send
		movlw	digit_9		; 9
		CALL	put_8880	; send
		movlw	digit_D		; D
		CALL	put_8880	; send

		GOTO	Idle		; idi iz pocetka kreni...

;***** Dial - zvanje brojeva *****

DialAlarm
		bsf		LED			; pali led
		bsf		bFRSTD		; reci da je ovo prvo zvanje
DialAlarm1
		clrf	EEADR		; =0
DialAlarm2
		bcf		bINTER		; mora mora

		CALL	EE_Read		; procitaj taj next karakter u EEDATA da vidimo jel #
		movlw	digit_#		; w=#
		subwf	EEDATA, 0	; w=EEDATA-#
		btfsc	STATUS, Z	; skif if not equal, do if equal
		GOTO	DialAlarm1	; sve iz pocetka dosli smo do kraja memorije (brojeva)

		; ako je first-dial nemoj ovu pauzu praviti nit spustat dzabe
		btfsc	bFRSTD		; do if set
		GOTO	DialAlarm2a

		bcf		ONHOOK		; spusti je prvo... jer odozdo sa DialAlarm7 se vracamo ovdje na naredno zvanje...
		movlw	d'12'		; w=?*Pauza1
		movwf	SEKUNDI		; sekundi=w
		CALL	BigWait		; cekaj dial-signal (naslijepo)

DialAlarm2a
		bsf		ONHOOK		; digni slusalicu
		movlw	d'18'		; w=?*Pauza1
		movwf	SEKUNDI		; sekundi=w
		CALL	BigWait		; cekaj dial-signal (naslijepo)

		bcf		bFRSTD		; nije vise first-dial i nadalje do narednog triggera alarma
		; zovi...!
DialAlarm3
		CALL	EE_Read		; procitaj broj u EEDATA

		movlw	digit_x		; w=*
		subwf	EEDATA, 0	; w=EEDATA-*
		btfsc	STATUS, Z	; skif if not equal, do if equal
		GOTO	DialAlarm4	; cekaj da se javi sad...

		movfw	EEDATA		; W=EEDATA

		btfsc	DIALMOD		; do if set
		CALL	put_8880	; posalji ga na MT8880
		btfss	DIALMOD		; do if clear
		CALL	puls_dial	; pulsiraj relej - pulsni mod biranja

		CALL	Pauza12		; cekaj malkice...

		incf	EEADR, 1	; eeadr++
		GOTO	DialAlarm3	; slijedeca cifra

		; svi brojevi su poslani na tel.liniju, cekamo sad da se javi i pritisne # a njemu
		; sviramo muziku u medjuvremenu :-)
DialAlarm4
		incf	EEADR, 1	; za slijedeci broj pozicija poslije pronadjene *

		movlw	d'37'		; w=?*Pauza1
		movwf	SEKUNDI		; sekundi=w
		CALL	BigWait		; cekaj da se javi (naslijepo)

		; recimo da se javio ili da zvoni ili koji vrag, sacemo mu pustati DTMF i cekati #
		; 1D1D ... 1D1D ... 1D1D (uiui ... uiui ... uiui) :)
		; palimo ovdje interrupt na 1min nakon cega interrupt setuje jedan bit koji nam ovdje
		; govori da predjemo na naredni broj jer se niko nije javio
		CALL	CkIni		; pali interrupts
DialAlarm5
		movlw	digit_1		; 1
		CALL	put_8880	; send
		movlw	digit_9		; 9
		CALL	put_8880	; send
		movlw	digit_1		; 1
		CALL	put_8880	; send
		movlw	digit_9		; 9
		CALL	put_8880	; send

		; jel se desio interrupt da provjerimo, da zovemo naredni broj?
		btfsc	bINTER		; do if set!
		CALL	DialAlarm2	; naredni broj zovi...

		; sad cekamo njega da kaze # pa da spustimo slusalicu
		movlw	d'8'		; w=?*Pauza1
		movwf	SEKUNDI		; sekundi=w
		CALL	BigWait		; cekaj da pritisne #

		btfss	MT_IRQ		; do if clear
		GOTO	DialAlarm6	; provjeri sta je to pritisnio kad se javio

		GOTO	DialAlarm5	; idi sviraj mu i cekaj da sta pritisne

		; pritisnuto je nesto, MT8880 je nesto dobio, da vidimo sta?
DialAlarm6
		CALL	CkDeIni		; gasi interrupte, covjek se je javio i pritisnuo NESTO

		CALL	get_8880	; procitaj broj koji je korisnik pritisnuo u W
		movwf	MT_DATA		; MT_DATA=W
		movlw	digit_#		; w=#
		subwf	MT_DATA, 0	; w=MT_DATA-#
		btfss	STATUS, Z	; do if clear -not equal
		GOTO	DialAlarm2	; idi ponovi proceduru ali sad za naredni broj u meRmoRiji

		; equal je! zavrsi zvanje
		bcf		ONHOOK		; spusti slusalicu
		bcf		LED			; gasi LED

		; cekaj da se alarm-signal ugasi
		btfss	GODIAL		; do if clear
		GOTO	$-1			; cekaj tu dok prestane signal

		GOTO	Idle		; gotova dojava, vrati se u normalni rezim rada

;***** KRAJ *****

		END
